{$MODE DELPHI}
program Add88ProToneToCfg;
// TiMidity++  cfg t@C̖ɃRgƂ SC-88Pro ̉FtB
// O͎ɏ]B
//  cfg t@C̓R}hCp[^Ɏw肷邩W͂Ƃ.
// o͕͂Wo.
// 2025/9/19 쐬
// 2025/9/22 EW͂삵ĂȂ̂ŒB
//           ETiMidity++41œsfviewer.exeDLScfg쐬łƂ̂Ƃ
//             ̂őΉBƌĂgm.dls炢ɂg͂Ȃ낤ǁB
// 2025/9/23 hCB
// 2025/9/24 EhZbgǉłȂȂĂ̂B
//           EDLScfgɑΉĂȂ̂B

uses Classes, SysUtils, RegExpr;

const
{$i BankArray.inc}
{$i DrumSetNameArray.inc}
{$i DrumSetArray.inc}

var
  CfgFileName, st, match1, match2, match3, match4, match5, match6: string;
  BankIdx, DrumSetNameIdx, DrumSetIdx: TStringList;
  re: TRegExpr;
  CfgFile: Textfile;
  n: Integer;

procedure CreateIdx;
var
  n: Integer;
begin
  BankIdx := TStringList.Create;
  DrumSetNameIdx := TStringList.Create;
  DrumSetIdx := TStringList.Create;
  for n := 0 to 773 do BankIdx.Add(BankArray[n, 0]);
  for n := 0 to 24 do DrumSetNameIdx.Add(DrumSetNameArray[n, 0]);
  for n := 0 to 2579 do DrumSetIdx.Add(DrumSetArray[n, 0]);
  BankIdx.Sorted := True;
  DrumSetNameIdx.Sorted := True;
  DrumSetIdx.Sorted := True
end;

function ThreeDigits(st: string): string;
var
  st2: string;
begin
  st2 := '00' + st;
  Delete(st2, 1, Length(st2) - 3);
  Result := st2
end;

procedure CloseIdx;
begin
  BankIdx.Free;
  DrumSetNameIdx.Free;
  DrumSetIdx.Free
end;

begin
  if ParamCount = 0 then
    CfgFile := Input
  else
  begin
    CfgFileName := ParamStr(1);
    if not FileExists(CfgFileName) then
    begin
      Writeln('̓t@C݂܂.');
      ExitCode := 1;
      Exit
    end;
    AssignFile(CfgFile, CfgFileName);
    Reset(CfgFile)
  end;
  re := TRegExpr.Create;
  re.ModifierI := True; //case-insensitive
  CreateIdx;
  while not Eof(CfgFile) do
  begin
    Readln(CfgFile, st);

    re.Expression := '(^ *[0-9]+ +%font +.+\.(?:sf2|dls)"? +)([0-9]+)( +)([0-9]+)( +)([0-9]+)';
    re.Exec(st);
    match1 := re.Match[1];
    match2 := re.Match[2];
    match3 := re.Match[3];
    match4 := re.Match[4];
    match5 := re.Match[5];
    match6 := re.Match[6];
    if match1 + match2 + match3 + match4 + match5 + match6 <> '' then
    begin
      if DrumSetIdx.Find(ThreeDigits(match2) + ':' + ThreeDigits(match4) +
        ':' + ThreeDigits(match6), n) then
        Writeln(st, ' #88Pro: ', DrumSetArray[n, 1])
      else
        Writeln(st);
        Continue
    end;

    re.Expression := '(^ *[0-9]+ +%(?:font|dls) +.+\.(?:sf2|dls)"? +)([0-9]+)( +)([0-9]+)';
    re.Exec(st);
    match1 := re.Match[1];
    match2 := re.Match[2];
    match3 := re.Match[3];
    match4 := re.Match[4];
    if match1 + match2 + match3 + match4  <> '' then
    begin
      if BankIdx.Find(ThreeDigits(match2) + ':' + ThreeDigits(match4), n) then
        Writeln(st, ' #88Pro: ', BankArray[n, 1])
      else
        Writeln(st);
        Continue
    end;

    re.Expression := '(^ *drumset +(?:gm2drum|sc55drum|sc88drum|sc88prodrum|sc8850drum|xgdrum|xgsfx126)? *)([0-9]+)';
    re.Exec(st);
    match1 := re.Match[1];
    match2 := re.Match[2];
    if match1 + match2  <> '' then
    begin
      if DrumSetNameIdx.Find(ThreeDigits(match2), n) then
        Writeln(st, ' #88Pro: ', DrumSetNameArray[n, 1])
      else
        Writeln(st);
        Continue
    end;

    Writeln(st)
  end;
  CloseIdx;
  re.Free;
  CloseFile(CfgFile)
end.
