unit Unit1;
{$MODE Delphi}
{ TenkaFRN (Lazarus版)を改造                   }
{ 「天下統一II」シリーズ用                     }
{ 対応したシナリオとセーブデータとを選択のこと }
{ 2020/12/22 作成                              }
{ 2021/1/8 メインウィンドウの表示位置を修正    }
{ 2025/8/30 表示1ヶ所訂正等                    }
interface

uses
  SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls;

type

  { TForm1 }

  TForm1 = class(TForm)
    ScenarioGroup: TRadioGroup;
    SaveDataGroup: TRadioGroup;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    Label1: TLabel;
    SelectDirectoryDialog1: TSelectDirectoryDialog;
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private 宣言 }
  public
    { Public 宣言 }
  end;

var
  Form1: TForm1;

implementation

uses IniFiles, Proc, RBNAM;
  {$R *.lfm}

const
  Dashes = '---';

var
  BaseDir: string;
  IniFile: TIniFile;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Application.Terminate
end;

procedure UpdateScreen;
var
  st: string;
  n: Integer;
begin
  with Form1 do
  begin
    ScenarioGroup.ItemIndex := IniFile.ReadInteger('Tenka2RN', 'Scenario', 0);
    for n := 0 to ScenarioGroup.Items.Count - 1 do
    begin
      st := BaseDir + Copy(ScenarioGroup.Items[n], 1, 2) + '\BUSYO.BIN';
      if not FileExists(st) then
        ScenarioGroup.Items[n] := Copy(ScenarioGroup.Items[n], 1, 2)
          + '  ' + Dashes
    end;
    SaveDataGroup.ItemIndex := IniFile.ReadInteger('Tenka2RN', 'SaveData', 0);
    for n := 0 to SaveDataGroup.Items.Count - 1 do
    begin
      st := BaseDir + Copy(SaveDataGroup.Items[n], 1, 2) + '\SYSTEM.BIN';
      if FileExists(st) then
        SaveDataGroup.Items[n] := Copy(SaveDataGroup.Items[n], 1, 2)
          + FormatDateTime('  dddddd hh:nn', FileDateToDateTime(FileAge(st)))
      else
        SaveDataGroup.Items[n] := Copy(SaveDataGroup.Items[n], 1, 2)
          + '  ' + Dashes
    end
  end
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if SelectDirectoryDialog1.Execute then
  begin
    BaseDir := SelectDirectoryDialog1.FileName + '\';
    IniFile.WriteString('Tenka2RN', 'BaseDir', BaseDir);
    IniFile.WriteInteger('Tenka2RN', 'Scenario', 0);
    IniFile.WriteInteger('Tenka2RN', 'SaveData', 0);
    IniFile.UpdateFile;
    UpdateScreen
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  st: string;
begin
  IniFile := TIniFile.Create(Copy(Paramstr(0), 1, Length(Paramstr(0)) - 4) +
    '.ini');
  st := IniFile.ReadString('Tenka2RN', 'BaseDir', 'Error');
  if (st = 'Error') or (st = '') then
    Button2Click(Sender)
  else
  begin
    BaseDir := st;
    if st[Length(st)] = '\' then Delete(st, Length(st), 1);
    SelectDirectoryDialog1.FileName := st;
    UpdateScreen
  end
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  IniFile.WriteInteger('Tenka2RN', 'Scenario', ScenarioGroup.ItemIndex);
  IniFile.WriteInteger('Tenka2RN', 'SaveData', SaveDataGroup.ItemIndex);
  IniFile.UpdateFile;
  IniFile.Free
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if (Pos(Dashes, ScenarioGroup.Items[ScenarioGroup.ItemIndex]) > 0) or
    (Pos(Dashes, SaveDataGroup.Items[SaveDataGroup.ItemIndex]) > 0) then
    ShowMessage('"---" は選択できません.')
  else if MessageDlg('実行しますか?',
    mtConfirmation, [mbYes, mbNo], 0) = mrYes then
      Execute(BaseDir + Copy(ScenarioGroup.Items[ScenarioGroup.ItemIndex], 1, 2)
        + '\', BaseDir + Copy(SaveDataGroup.Items[SaveDataGroup.ItemIndex], 1, 2)
        + '\')
end;

initialization
  KaimeiList := TStringList.Create

finalization
  KaimeiList.Free

end.
