unit Proc;
{$MODE Delphi}

interface

procedure Execute(ScenarioPath, SaveDataPath: string);

implementation

uses SysUtils, Dialogs, RBNAM;

const
  Si = #$8e#$6b; //'嗣'

type
  TBusyo = record
             Name: array[1..12] of Char;
             Others: array[1..20] of Byte
           end;

var
  ScenarioBusyoF, SaveDataBusyoF: file of TBusyo;
  ScenarioBusyo, SaveDataBusyo: TBusyo;

procedure Execute(ScenarioPath, SaveDataPath: string);

var
  n, m: Integer;
  st: string;

function IsKaimei(Name: string): Boolean;
//改名後の名前かどうか
var
  n: Integer;
begin
  Result := False;
  for n := 0 to KaimeiList.Count - 1 do
    if Name = KaimeiList[n] then
    begin
      Result := True;
      Break
    end
end;

begin
  if KaimeiList.Count = 0 then
    if FileExists(ScenarioPath + 'RBNAM.BIN') then //「天下統一II」には存在しない
      ReadRBNAM(ScenarioPath + 'RBNAM.BIN');
  AssignFile(ScenarioBusyoF, ScenarioPath + 'BUSYO.BIN');
  Reset(ScenarioBusyoF);
  AssignFile(SaveDataBusyoF, SaveDataPath + 'BUSYO.BIN');
  Reset(SaveDataBusyoF);
  for n := 0 to 1023 do
  begin
    Seek(ScenarioBusyoF, n);
    Read(ScenarioBusyoF, ScenarioBusyo);
    Seek(SaveDataBusyoF, n);
    Read(SaveDataBusyoF, SaveDataBusyo);
    if (ScenarioBusyo.Name <> SaveDataBusyo.Name) and
      not IsKaimei(SaveDataBusyo.Name)then
    begin
      if SaveDataBusyo.Name <> ScenarioBusyo.Name then st := ScenarioBusyo.Name;
      if st[7] <> ' ' {名前が3文字の場合} then
        //st := Copy(st, 1, 9) + Utf8ToAnsi('嗣') //Utf8ToAnsi がなぜか動作しない
        st := Copy(st, 1, 9) + Si
      else
        //st := Copy(st, 1, 6) + Format('%6s', [Trim(Copy(st, 7, 6)) + Utf8ToAnsi('嗣')])  //Utf8ToAnsi がなぜか動作しない
        st := Copy(st, 1, 6) + Format('%6s', [Trim(Copy(st, 7, 6)) + Si]);
      for m := 1 to 12 do SaveDataBusyo.Name[m] := st[m];
      Seek(SaveDataBusyoF, n);
      Write(SaveDataBusyoF, SaveDataBusyo)
    end
  end;
  CloseFile(ScenarioBusyoF);
  CloseFile(SaveDataBusyoF);
  ShowMessage('データを書き換えました.')
end;

end.


