{$MODE DELPHI}
unit TenkaLib;
{ uVṽf[^ǂނ߂̃Cu[                 }
{>> September 15, 1989  by M.Y.                                }
{>> Modified  November 19, 1989                                }
{>> Added 'daimyou_rec_type' & 'kamei'  December 29, 1989      }
{>> Added 'system_rec_type'  December 30, 1989                 }
{>> Added 'siro_rec_type' & 'kuni_rec_type'  December 31, 1989 }
{>> Added 'keiro_siro' to 'siro_rec_type' and 'siro1' & 'siro2'}
{   to 'kuni_rec_type' with reference to PC-VAN > Gamers Club  }
{   and added 'ringoku_array_const'  January 14, 1990          }
{Turbo Pascal  Free Pascal ɈڐA  2021/3/8                }

interface

type
  year_type = 1551..1623;
  season_type = (spring,summer,fall,winter);
  kuni_type = 0..57;
  ie_type = 0..57;
  siro_type = 0..249;
  sihai_type = (misihai,hansihai,zensihai);
  tousyu_type = 0..840;
  kokumei_type = string[6];
  kamei_type = string[8];
  tihou_type = 0..9;

  busyou_rec_type = record
		      namae    : array[1..12] of char;
		      unknown1 : array[0..1] of byte; { 00h 00h }
		      nenrei   : byte;
		      gunzi    : byte;
		      naisei   : byte;
		      tyuusei  : byte;
		      houroku  : byte;
		      heisuu   : byte;
		      teppou   : byte;
		      touzyou_nen   : byte;
		      touzyou_koku  : byte;
		      touzyou_ke    : byte;
		      touzyou_siro  : byte;
		      unknown2      : byte; { 00h }
		      ikisaki_siro : byte;
		      unknown3      : byte;
		      syurui : byte; {喼Ƃ̂ƌp͂PA
				      ꂫ̗ނ͂QȂ͂O}
		      unknown4 : array[0..2] of byte  { FFh FFh FFh }
		    end;

  daimyou_rec_type = record
		       unknown1 : array[0..2] of byte;
		       isin     : byte;
		       unknown2 : array[4..117] of byte;
		       doumei1  : byte;
		       doumei2  : byte;
		       doumei3  : byte;
		       unknown3 : array[121..130] of byte;
		       siki     : byte;
		       unknown4 : array[132..141] of byte
		     end;
		       
  system_rec_type = record
		       unknown1 : byte;
		       sentaku_daimyou : byte; {ObłPQ喼IB
						R`őSTW喼I}
		       unknown2 : array[2..21] of byte
		    end;
		    					       
  siro_rec_type = record
		    namae : array[0..5] of char;
		    unknown1 : array[6..7] of byte; 
		    level : byte;
		    keiro_siro : array[9..13] of byte;
		    unknown2 : array[14..47] of byte
		  end;
		  
  kuni_rec_type = record
		    namae : array[0..5] of char;
		    unknown1 : array[6..11] of byte;
		    koku : word;
		    max_koku : word;
		    mati : word;
		    max_mati : word;
		    juumin : byte;
		    siro1 : siro_type;
		    siro2 : siro_type;
		    unknown2 : array[23..30] of byte;
		    tihou : tihou_type;
		    unknown3 : array[32..39] of byte
		  end;		     		  
  
const
  ringoku_array_const : array[kuni_type,0..5] of byte = 
    (
    (  1,  2,255,255,255,255),(  0,  3,  6, 19,255,255),
    (  0, 19,255,255,255,255),(  1,  4,  6,255,255,255),
    (  3,  5,  6,  8,255,255),(  4,255,255,255,255,255),
    (  1,  3,  4,  7,255,255),(  6,  8, 18, 19,255,255),
    (  4,  7,  9,255,255,255),(  8, 10, 16,255,255,255),
    (  9, 11, 16,255,255,255),( 10, 12, 17,255,255,255),
    ( 11, 14, 17,255,255,255),( 12, 14, 15,255,255,255),
    ( 13, 15, 17, 23, 24,255),( 13, 14, 25, 30,255,255),
    (  9, 10, 17, 18,255,255),( 11, 12, 14, 16, 18,255),
    (  7, 16, 17, 19,255,255),(  1,  2,  6, 18, 20,255),
    ( 19, 21, 22,255,255,255),( 20, 23,255,255,255,255),
    ( 20, 21, 23,255,255,255),( 14, 22, 24, 27,255,255),
    ( 14, 23, 25,255,255,255),( 15, 24, 26,255,255,255),
    ( 25, 27, 28, 29, 30,255),( 26, 28, 32, 33,255,255),
    ( 26, 27, 29, 45,255,255),( 26, 28, 30, 31, 45,255),
    ( 15, 26, 29, 31,255,255),( 30, 29, 45,255,255,255),
    ( 23, 27, 33,255,255,255),( 27, 32, 34, 37,255,255),
    ( 33, 35, 37,255,255,255),( 34, 36, 38, 41,255,255),
    ( 35, 42, 44,255,255,255),( 28, 33, 34, 38, 39,255),
    ( 35, 37, 39, 40,255,255),( 37, 38, 40, 46,255,255),
    ( 38, 39, 41,255,255,255),( 35, 40, 42, 46,255,255),
    ( 36, 41, 43, 47,255,255),( 42, 44, 47, 49,255,255),
    ( 36, 43, 49,255,255,255),( 28, 29, 31, 46, 48,255),
    ( 39, 41, 45, 47, 48,255),( 42, 43, 46, 48, 50,255),
    ( 45, 46, 47,255,255,255),( 43, 44, 50, 51,255,255),
    ( 47, 49, 52, 54, 55,255),( 49, 53, 54,255,255,255),
    ( 50, 52, 53, 54,255,255),( 51, 52, 54,255,255,255),
    ( 50, 52, 53, 55, 56, 57),( 50, 54, 56,255,255,255),
    ( 54, 55, 57,255,255,255),( 54, 56,255,255,255,255)
    );

procedure read_TURN_BIN(inpF_name:string);

function TURN_current_turn : word;

function TURN_kokudaka(y:year_type; s:season_type):word;

function TURN_zyun_i(y:year_type; s:season_type):byte;

function TURN_sihai(y:year_type; s:season_type; k:kuni_type):sihai_type;

function TURN_tousyu(y:year_type; s:season_type):tousyu_type;

function TURN_kokumei(k:kuni_type):kokumei_type;

function kamei(i:ie_type):kamei_type;


implementation

var
  TURN_tousyu_array : array[year_type,season_type] of word;
  TURN_kokudaka_array : array[year_type,season_type] of word;
  TURN_zyun_i_array : array[year_type,season_type] of byte;
  TURN_sihai_array : array[year_type,kuni_type] of byte;

const
  kokumei_const : array[kuni_type] of kokumei_type =
    ('k','엤','  oH','  헤','  ','  㑍','  ','  ',
     '  ','  ','  x','  ]','  O','  ','  Z','  ɐ',
     '  b','MZ','kMZ','  z','  z','  \o','  ','  zO',
     'kߍ]','ߍ]','  R','  Og','  ے','  ͓','  a','  I',
     '  O','  An','  ','  o_','  Ό','  d','  ','  O',
     '  ','  ','  |','  h','  ','  g','  ]','  ɗ\',
     '  y','  LO','  L','  }O','  }','  O','  ','  ',
     '  ','  F');
     
const     
  kamei_const : array[ie_type] of kamei_type =
    ('ɒB    ','    ','ŏ    ','|    ','    ','    ',
     'Fs{  ','R㐙','J㐙','k    ','    ','є    ',
     '    ','Dc    ','֓    ','k    ','c    ','}  ',
     '    ','㐙    ','_    ','R    ','x~    ','q    ',
     '    ','Zp    ','    ','g  ','א    ','OD    ',
     'i    ','R    ','F    ','R    ','R    ','q    ',
     '}  ','Y    ','ԏ    ','F쑽  ','O    ',']c    ',
     'ї    ','      ','    ','א    ','\    ','͖    ',
     '@䕔','Fs{  ','F    ','H    ','    ','  ',
     '    ','ɓ    ','̕t    ','    ');
      
procedure read_TURN_BIN(inpF_name:string);
var
  inpF : file;
begin
  assign(inpF,inpF_name);
  reset(inpF,1);
  blockread(inpF,TURN_tousyu_array,72*4*2);
  blockread(inpF,TURN_kokudaka_array,72*4*2);
  blockread(inpF,TURN_zyun_i_array,72*4*1);
  blockread(inpF,TURN_sihai_array,72*58*1);
  close(inpF)
end;

function TURN_current_turn : word;
var
  n : word;
  y : year_type;
  s : season_type;
begin
  n := 1;
  for y := 1551 to 1623 do
  begin
    for s := spring to winter do
    begin
      if TURN_zyun_i_array[y,s] <> 0 then inc(n)
      else
      begin
	TURN_current_turn := n - 1;
	exit
      end
    end
  end
end;

function TURN_kokudaka(y:year_type; s:season_type):word;
begin
  TURN_kokudaka := TURN_kokudaka_array[y,s]
end;

function TURN_zyun_i(y:year_type; s:season_type):byte;
begin
  TURN_zyun_i := TURN_zyun_i_array[y,s]
end;

function TURN_sihai(y:year_type; s:season_type; k:kuni_type):sihai_type;
var
  data : byte;
begin
  data := TURN_sihai_array[y,k];
  TURN_sihai := sihai_type((data shr (byte(s)*2)) and 3);
end;
{̎xz󋵂͂PoCgŎ̂悤ɕ\ĂB                    }
{f[^QSĝƂƁA                                        }
{    Q   S                                                           }
{  00 10 01 00                                                         }
{EAtOOAāOPAHPOA~OOŁAOO͖xzAOP}
{xzAPO͑SxzӖĂB                                  }

function TURN_tousyu(y:year_type; s:season_type):tousyu_type;
begin
  TURN_tousyu := TURN_tousyu_array[y,s]
end;

function TURN_kokumei(k:kuni_type):kokumei_type;
begin
  TURN_kokumei := kokumei_const[k]
end;

function kamei(i:ie_type):kamei_type;
begin
  kamei := kamei_const[i]
end;  


end.