{$MODE DELPHI}
program Tenka;
{January 24, 1990  by M.Y.}
{Free Pascal Compiler ɈڐA  September 9, 2025}

uses TenkaLib, Crt2, SysUtils;


var
  select : byte;


procedure Shuffle(var array_var; elem_size, elem_num:word);
{zϐ̗vfVbtvO}
{October 15, 1989  by M.Y.}
{Modified  October 22, 1989}
{Modidied  September 9, 2025}

type
  array_type = array[0..65535] of byte;

var
  n :word;

procedure swap_value(elem1,elem2:word);
var
  temp : byte;
  n : word;
begin
  for n := 0 to elem_size - 1 do
  begin
    temp := array_type(array_var)[elem1 * elem_size + n];
    array_type(array_var)[elem1 * elem_size + n]
	 := array_type(array_var)[elem2 * elem_size + n];
    array_type(array_var)[elem2 * elem_size + n] := temp
  end
end;

begin
  randomize;
  for n := 0 to elem_num - 1 do
    swap_value(n, random(elem_num));
end;


function cut_left_rec(var st:string):string;
{September 3, 1989  by M.Y.}
{ st ̈ԍ̃R[h؂āÃR[hԂB       }
{st = '  AAA   BBB     CCC  ' ̂ƂɁAst = '   BBB     CCC  ' ƂA}
{'AAA' Ԃ̂ƂB                                             }
var
  pos_of_SP : byte;
begin
  repeat
    pos_of_SP := pos(' ', st);
    if pos_of_SP = 1 then delete(st,1,1)
  until pos_of_SP <> 1;
  if pos_of_SP = 0 then
  begin
    cut_left_rec := st;
    st := '';
  end
  else
  begin
    cut_left_rec := copy(st,1,pos_of_SP-1);
    delete(st,1,pos_of_SP-1)
  end
end;


procedure edit_BUSYO_BIN;
{September 3, 1989  by M.Y. }
{Modified  November 19, 1989}

{ahm t@C  t@CɕϊĂGfB^ŏB}
{ۂɊeڊԂ̃Xy[X͕̐ςĂ܂ĂBPs }
{QTTȉ̂ƁB܂As * ̍s͒ߍsƂĈB      }

var
  busyou_rec : busyou_rec_type;
  choice : byte;

procedure read_bin;
var
  inpF_name, outpF_name : string[80];
  inpF : file of busyou_rec_type;
  outpF : text;
begin
  writeln;
  write('ǂݍ ahm t@C ..... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write('o  t@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  writeln(outpF,'*O          N  R      \    SC',
		 '  oN              s@s@s@');
  while not eof(inpF) do
  begin
    read(inpF,busyou_rec);
    with busyou_rec do
    begin
      write(outpF,namae);
      write(outpF,nenrei:6);
      write(outpF,gunzi:6);
      write(outpF,naisei:6);
      write(outpF,tyuusei:6);
      write(outpF,houroku:6);
      write(outpF,heisuu:6);
      write(outpF,teppou:6);
      write(outpF,touzyou_nen:6);
      write(outpF,touzyou_koku:6);
      write(outpF,touzyou_ke:6);
      write(outpF,touzyou_siro:6);
      write(outpF,unknown2:6);
      write(outpF,ikisaki_siro:6);
      write(outpF,unknown3:6);
      write(outpF,syurui:6);
      write(outpF,^m,^j)
    end {of with}
  end;
  close (inpF);
  close (outpF);
end;

procedure write_bin;
var
  inpF_name, outpF_name : string[80];
  outpF : file of busyou_rec_type;
  inpF : text;
  new_data : string;
  n, code : integer;
procedure check_num;
begin
  if code <> 0 then
  begin
    writeln(^g,busyou_rec.namae,'̏̐̕\LɌ肪');
    close(inpF);
    close(outpF);
    halt(1)
  end
end;
begin
  writeln;
  write('ǂݍ  t@C ... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write('o ahm t@C ..... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  ;
  while not eof(inpF) do
  begin
    repeat
      readln(inpF,new_data)
    until new_data[1]<>'*'; {'*' Ŏn܂s͒ߍsƂăXLbv}
    with busyou_rec do
    begin
      for n := 1 to 12 do
	namae[n] := new_data[n];
      delete(new_data,1,12);
      val(cut_left_rec(new_data),nenrei,code);  check_num;
      val(cut_left_rec(new_data),gunzi, code);  check_num;
      val(cut_left_rec(new_data),naisei,code);  check_num;
      val(cut_left_rec(new_data),tyuusei,code); check_num;
      val(cut_left_rec(new_data),houroku,code); check_num;
      val(cut_left_rec(new_data),heisuu, code); check_num;
      val(cut_left_rec(new_data),teppou, code); check_num;
      val(cut_left_rec(new_data),touzyou_nen, code);check_num;
      val(cut_left_rec(new_data),touzyou_koku,code);check_num;
      val(cut_left_rec(new_data),touzyou_ke,  code);check_num;
      val(cut_left_rec(new_data),touzyou_siro,code);check_num;
      val(cut_left_rec(new_data),unknown2,code)    ;check_num;
      val(cut_left_rec(new_data),ikisaki_siro,code);check_num;
      val(cut_left_rec(new_data),unknown3,code)    ;check_num;
      val(cut_left_rec(new_data),syurui, code); check_num;
      unknown1[0] := $00; unknown1[1] := $00;
      unknown4[0] := $ff; unknown4[1] := $ff; unknown4[2] := $ff
    end; {of with}
    write(outpF,busyou_rec)
  end;
  close(inpF);
  close(outpF)
end;

begin
  clrscr;
  writeln('@uVv "BUSYO.BIN" ',
	  'GfBbg邽߂̃vO@');
  writeln;
  writeln('1. q@ahm');
  writeln('2. v@ahm');
  writeln;
  write  ('ԍI ... ');
  readln(choice);
  case choice of
    1 : read_bin;
    2 : write_bin
  end
end; {of edit_BUSYO_BIN}


procedure display_TURN_BIN;
begin
  //Ȃ
end;


procedure spoil_kyuusyuu;
{October 10, 1989  by M.Y.}

var
  inpF_name, outpF_name : string[80];
  inpF, outpF : file of busyou_rec_type;
  percent_str : string;
  percent : real;
  code : integer;
  data : busyou_rec_type;

begin
  clrscr;
  writeln('@Bn̔̕\͂ꗥɉvO@');
  writeln;
  write  ('̓t@C ... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write  ('o̓t@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  writeln;
  write  ('p[Zg܂ ... ');
  readln(percent_str);
  if pos('.',percent_str) = 0 then percent_str := percent_str + '.0';
  val(percent_str,percent,code);
  ;
  while not eof(inpF) do
  begin
    read(inpF,data);
    with data do
    begin
      if ((touzyou_siro >= 209) and (touzyou_siro <= 249)) or
	 ((touzyou_ke >= 49) and (touzyou_ke <= 57)) or
	 ((touzyou_koku >= 49) and (touzyou_koku <= 57)) then
      begin
	gunzi :=  round(gunzi * (100.0 - percent) / 100.0);
	if gunzi = 0 then gunzi := 1;
	naisei :=  round(naisei * (100.0 - percent) / 100.0);
	if naisei = 0 then naisei := 1
      end
    end {of with};
    write(outpF,data)
  end {of while};
  ;
  close(inpF);
  close(outpF)
end; {of spoil_kyuusyuu}


procedure randomize_nouryoku;
{October 16, 1989  by M.Y.}

var
  inpF_name, outpF_name : string[80];
  inpF, outpF : file of busyou_rec_type;
  data : busyou_rec_type;
  buf : array[tousyu_type] of record
				gunzi : byte;
				naisei : byte
			      end;
  shuffle_num, max_shuffle_num : word;

begin
  clrscr;
  writeln('@̔\͂_ɐݒ肷vO@');
  writeln;
  write  ('̓t@C ... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write  ('o̓t@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  ;
  with data do
  begin
    shuffle_num := 0;
    while not eof(inpF) do
    begin
      read(inpF,data);
      if syurui <> 2 then
      begin
	buf[shuffle_num].gunzi  := gunzi;
	buf[shuffle_num].naisei := naisei;
	inc(shuffle_num)
      end
    end;
    max_shuffle_num := shuffle_num - 1;
    shuffle(buf,2,max_shuffle_num+1);
    close(inpF);
    reset(inpF);
    shuffle_num := 0;
    while not eof(inpF) do
    begin
      read(inpF,data);
      if syurui <> 2 then
      begin
	gunzi  := buf[shuffle_num].gunzi;
	naisei := buf[shuffle_num].naisei;
	inc(shuffle_num)
      end
      else
      begin
	gunzi  := 1;
	naisei := 1
      end;
      write(outpF,data)
    end
  end {of with}
  ;
  close(inpF);
  close(outpF)
end; {of randomize_nouryoku}


procedure atotugi;
{December 23, 1989  by M.Y.}

var
  inpF1_name, inpF2_name, outpF_name : string[80];
  inpF1, inpF2 : file of busyou_rec_type;
  outpF : text;
  data1, data2 : busyou_rec_type;
  dummy : char;

begin
  clrscr;
  writeln ('@̂Ƃł҂',
	   'ꗗ\쐬vO@');
  writeln;
  write  ('̃t@C(BUSYO.BIN) ... ');
  readln(inpF1_name);
  assign(inpF1,inpF1_name);
  reset(inpF1);
  write  ('݂̃t@C(BUSYO.BIN) ... ');
  readln(inpF2_name);
  assign(inpF2,inpF2_name);
  reset(inpF2);
  write  ('o̓t@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  ;
  while not eof(inpF1) do
  begin
    read(inpF1,data1);
    read(inpF2,data2);
    if data2.touzyou_nen <> $ff then
      if data1.namae <> data2.namae then
	writeln(outpF, data1.namae, '', copy(data2.namae,7,6));
  end;
  ;
  close(inpF1);
  close(inpF2);
  close(outpF);
  if UpperCase(outpF_name) = 'CON' then
  begin
    writeln('L[ĉ');
    dummy := readkey;
  end
end; {of atotugi}


procedure edit_DAIMYO_BIN;
{December 29, 1989  by M.Y. }

{ahm t@C  t@CɕϊĂGfB^ŏB}
{ۂɊeڊԂ̃Xy[X͕̐ςĂ܂ĂBPs }
{QTTȉ̂ƁB܂As * ̍s͒ߍsƂĈB      }

var
  daimyou_rec : daimyou_rec_type;
  choice : byte;

procedure read_bin;
var
  inpF_name, outpF_name : string[80];
  inpF : file of daimyou_rec_type;
  outpF : text;
  i : byte;
  k1,k2,k3 : kamei_type;
begin
  i := 0;
  writeln;
  write('ǂݍ ahm t@C ..... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write('o  t@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  writeln(outpF,'* АM@ƂP@ƂQ@ƂR@mC');
  writeln(outpF,'******************************************');
  while not eof(inpF) do
  begin
    read(inpF,daimyou_rec);
    with daimyou_rec do
    begin
      writeln(outpF,'* ',i,': ',kamei(i)); inc(i);
      write(outpF,isin:6);       
      write(outpF,doumei1:10);
      write(outpF,doumei2:10);
      write(outpF,doumei3:10);
      write(outpF,siki:6);    
      write(outpF,^m,^j);
      if (doumei1<>$ff) or (doumei2<>$ff) or (doumei3<>$ff) then
      begin
	if doumei1=$ff then k1:='        ' else k1:=kamei(doumei1);
	if doumei2=$ff then k2:='        ' else k2:=kamei(doumei2);
	if doumei3=$ff then k3:='        ' else k3:=kamei(doumei3);
	writeln(outpF,'*       ',k1,'  ',k2,'  ',k3);
      end	
    end {of with}
  end;
  close (inpF);
  close (outpF);
end;

procedure write_bin;
var
  inpF_name, orgF_name, outpF_name : string[80];
  orgF, outpF : file of daimyou_rec_type;
  inpF : text;
  new_data : string;
  org_data : daimyou_rec_type;
  code : integer;
  i : ie_type;
procedure check_num;
begin
  if code <> 0 then
  begin
    writeln(^g,kamei(i),'̏̐̕\LɌ肪');
    close(inpF);
    close(outpF);
    halt(1)
  end
end;
begin
  i := 0;
  writeln;
  write('ǂݍ  t@C ... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write(' "DAIMYO.BIN" t@C ... ');
  readln(orgF_name);
  assign(orgF,orgF_name);
  reset(orgF);
  write('o ahm t@C ..... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  ;
  while not eof(inpF) do
  begin
    repeat
      readln(inpF,new_data)
    until new_data[1]<>'*'; {'*' Ŏn܂s͒ߍsƂăXLbv}
    read(orgF,org_data);
    with daimyou_rec do
    begin
      unknown1 := org_data.unknown1;    
      val(cut_left_rec(new_data),isin,code);     check_num;
      unknown2 := org_data.unknown2;
      val(cut_left_rec(new_data),doumei1, code); check_num;
      val(cut_left_rec(new_data),doumei2, code); check_num;
      val(cut_left_rec(new_data),doumei3, code); check_num;
      unknown3 := org_data.unknown3;
      val(cut_left_rec(new_data),siki,    code); check_num;
      unknown4 := org_data.unknown4
    end; {of with}
    inc(i);
    write(outpF,daimyou_rec)
  end;
  close(inpF);
  close(orgF);
  close(outpF)
end;

begin
  clrscr;
  writeln('@uVv "DAIMYO.BIN" ',
	  'GfBbg邽߂̃vO@');
  writeln;
  writeln('1. q@ahm');
  writeln('2. v@ahm');
  writeln;
  write  ('ԍI ... ');
  readln(choice);
  case choice of
    1 : read_bin;
    2 : write_bin
  end
end; {of edit_DAIMYO_BIN}


procedure kaisi_daimyou_suu;
{December 30, 1989  by M.Y. }

var
  system_rec : system_rec_type;
  inpF_name, outpF_name : string[80];
  inpF, outpF : file of system_rec_type;
  choice : byte;  
begin
  clrscr;
  writeln('@uVv̊Jn喼IvO@');
  writeln;
  write('ǂݍ \NEW.DAT\SYSTEM.BIN t@C ... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  read(inpF,system_rec);
  write('o t@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  ;
  writeln;
  writeln('1. PQP');
  writeln('2. TWP');
  writeln;
  write  ('ԍI ... ');
  choice := 0;
  repeat
    readln(choice);
    case choice of
      1 : system_rec.sentaku_daimyou := 12;
      2 : system_rec.sentaku_daimyou := 58
    end
  until (choice=1) or (choice=2);
  ;
  write(outpF,system_rec);
  close(inpF);    
  close(outpF)  
end; {of kaisi_daimyou_suu}


procedure edit_SIRO_BIN;
{December 31, 1989  by M.Y. }
{Modified  January 14, 1990 }

{ahm t@C  t@CɕϊĂGfB^ŏB}
{ۂɊeڊԂ̃Xy[X͕̐ςĂ܂ĂBPs }
{QTTȉ̂ƁB܂As * ̍s͒ߍsƂĈB      }

var
  siro_rec : siro_rec_type;
  choice : byte;

procedure read_bin;
var
  inpF_name, outpF_name : string[80];
  inpF : file of siro_rec_type;
  outpF : text;
begin
  writeln;
  write('ǂݍ ahm t@C ..... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write('o  t@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  writeln(outpF,'* 閼  LEVEL');
  writeln(outpF,'*************');
  while not eof(inpF) do
  begin
    read(inpF,siro_rec);
    write(outpF,siro_rec.namae,'  ');       
    write(outpF,siro_rec.level:2,^m,^j)
  end;
  close (inpF);
  close (outpF);
end;

procedure write_bin;
var
  inpF_name, orgF_name, outpF_name : string[80];
  orgF, outpF : file of siro_rec_type;
  inpF : text;
  new_data : string;
  org_data : siro_rec_type;
  n,code : integer;
procedure check_num;
begin
  if code <> 0 then
  begin
    writeln(^g,siro_rec.namae,'̏̐̕\LɌ肪');
    close(inpF);
    close(outpF);
    halt(1)
  end
end;
begin
  writeln;
  write('ǂݍ  t@C ... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write(' "SIRO.BIN" t@C ... ');
  readln(orgF_name);
  assign(orgF,orgF_name);
  reset(orgF);
  write('o ahm t@C ..... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  ;
  while not eof(inpF) do
  begin
    repeat
      readln(inpF,new_data)
    until new_data[1]<>'*'; {'*' Ŏn܂s͒ߍsƂăXLbv}
    read(orgF,org_data);
    for n := 0 to 5 do
      siro_rec.namae[n] := new_data[n+1];  
    delete(new_data,1,6);
    siro_rec.keiro_siro := org_data.keiro_siro;         
    siro_rec.unknown1 := org_data.unknown1;    
    val(cut_left_rec(new_data),siro_rec.level,code); check_num;
    siro_rec.unknown2 := org_data.unknown2;
    write(outpF,siro_rec)
  end;
  close(inpF);
  close(orgF);
  close(outpF)
end;

begin
  clrscr;
  writeln('@uVv "SIRO.BIN" ',
	  'GfBbg邽߂̃vO@');
  writeln;
  writeln('1. q@ahm');
  writeln('2. v@ahm');
  writeln;
  write  ('ԍI ... ');
  readln(choice);
  case choice of
    1 : read_bin;
    2 : write_bin
  end
end; {of edit_SIRO_BIN}


procedure edit_KUNI_BIN;
{December 31, 1989  by M.Y. }
{Modified  January 14, 1990 }

{ahm t@C  t@CɕϊĂGfB^ŏB}
{ۂɊeڊԂ̃Xy[X͕̐ςĂ܂ĂBPs }
{QTTȉ̂ƁB܂As * ̍s͒ߍsƂĈB      }

var
  kuni_rec : kuni_rec_type;
  choice : byte;

procedure read_bin;
var
  inpF_name, outpF_name : string[80];
  inpF : file of kuni_rec_type;
  outpF : text;
begin
  writeln;
  write('ǂݍ ahm t@C ..... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write('o  t@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  writeln(outpF,'*   ΍  ő    ő  Z  n');
  writeln(outpF,'*             ΍          ');
  writeln(outpF,'********************************************');
  while not eof(inpF) do
  begin
    read(inpF,kuni_rec);
    write(outpF,kuni_rec.namae);
    write(outpF,kuni_rec.koku:6);
    write(outpF,kuni_rec.max_koku:6);
    write(outpF,kuni_rec.mati:6);
    write(outpF,kuni_rec.max_mati:6);
    write(outpF,kuni_rec.juumin:6);       
    write(outpF,kuni_rec.tihou:6,^m,^j)
  end;
  close (inpF);
  close (outpF);
end;

procedure write_bin;
var
  inpF_name, orgF_name, outpF_name : string[80];
  orgF, outpF : file of kuni_rec_type;
  inpF : text;
  new_data : string;
  org_data : kuni_rec_type;
  n,code : integer;
procedure check_num;
begin
  if code <> 0 then
  begin
    writeln(^g,kuni_rec.namae,'̏̐̕\LɌ肪');
    close(inpF);
    close(outpF);
    halt(1)
  end
end;
begin
  writeln;
  write('ǂݍ  t@C ... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write(' "KUNI.BIN" t@C ... ');
  readln(orgF_name);
  assign(orgF,orgF_name);
  reset(orgF);
  write('o ahm t@C ..... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  ;
  while not eof(inpF) do
  begin
    repeat
      readln(inpF,new_data)
    until new_data[1]<>'*'; {'*' Ŏn܂s͒ߍsƂăXLbv}
    read(orgF,org_data);
    for n := 0 to 5 do
      kuni_rec.namae[n] := new_data[n+1];  
    delete(new_data,1,6);          
    kuni_rec.unknown1 := org_data.unknown1;    
    val(cut_left_rec(new_data),kuni_rec.koku,code);     check_num;
    val(cut_left_rec(new_data),kuni_rec.max_koku,code); check_num;
    val(cut_left_rec(new_data),kuni_rec.mati,code);     check_num;
    val(cut_left_rec(new_data),kuni_rec.max_mati,code); check_num;
    val(cut_left_rec(new_data),kuni_rec.juumin,code);   check_num;
    kuni_rec.siro1 := org_data.siro1;
    kuni_rec.siro2 := org_data.siro2; 
    kuni_rec.unknown2 := org_data.unknown2;
    val(cut_left_rec(new_data),kuni_rec.tihou,code);    check_num;
    kuni_rec.unknown3 := org_data.unknown3;    
    write(outpF,kuni_rec)
  end;
  close(inpF);
  close(orgF);
  close(outpF)
end;

begin
  clrscr;
  writeln('@uVv "KUNI.BIN" ',
	  'GfBbg邽߂̃vO@');
  writeln;
  writeln('1. q@ahm');
  writeln('2. v@ahm');
  writeln;
  write  ('ԍI ... ');
  readln(choice);
  case choice of
    1 : read_bin;
    2 : write_bin
  end
end; {of edit_KUNI_BIN}


procedure busyou_bunsan;
{January 15, 1990  by M.Y.}
{Modified  September 9, 2025}

{̓oꍑ𕪎U邽߂̃vOB                              }
{אڍioĤ鍑jwړB                          }
{PړƂ͂Ƃ́Aׂ̍܂͍̍P_ɑIA}
{ړ邱ƂӖB                                              }

var
  inpF, outpF : file of busyou_rec_type;
  inpF_name, outpF_name : string[80];
  hosuu : word;
  
procedure main;
var
  rec : busyou_rec_type;
  n : word;        
function idou_saki(k:kuni_type):kuni_type;
var
  ringoku_suu, n, result_ : byte;
begin
  for n := 0 to 5 do
    if ringoku_array_const[k,n] <> 255 then ringoku_suu := n + 1;
  result_ := random(ringoku_suu+1);
    {0..ringoku_suu _ɕԂ̂ŁA0..ringoku_suu-1 ɑΉ
     ړ׍֐lƂAringoku_suu Ԃꂽꍇ͈̂܂܊
     lƂB҂́AړȂƂӖB}
  if result_ = ringoku_suu then
    idou_saki := k
  else
    idou_saki := ringoku_array_const[k,result_]   
end;
begin
  while not eof(inpF) do 
  begin
    read(inpF,rec);  
    if (rec.touzyou_koku <> 255) and (rec.touzyou_siro = 255) then
    begin
      for n := 1 to hosuu do
	rec.touzyou_koku := idou_saki(rec.touzyou_koku);
    end;
    write(outpF,rec);
  end {while not eof}
end;

begin
  clrscr;
  writeln('@̓oꍑ𕪎U邽߂̃vO@');
  writeln;
  write  ('ǂݍ "BUSYO.BIN" t@C ... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write  ('ot@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  write  ('ړ邩 ... '); 
  readln(hosuu);
  randomize;
  ;
  main;
  ;
  close(inpF);
  close(outpF)    
end {of busyou_bunsan};

  
procedure kyuusyuu_siro_kyouka;
{Bn̏郌xꗥɏグvO}
{January 15, 1990  by M.Y.}

var
  inpF, outpF : file of siro_rec_type;
  inpF_name, outpF_name : string[80];
  percentage : real;
  new_level : word;
  rec : siro_rec_type;
  siro_No : siro_type;
  
begin
  clrscr;
  writeln('@Bn̏郌xグvO@');
  writeln;
  write  ('ǂݍ "SIRO.BIN" t@C ... ');
  readln(inpF_name);
  assign(inpF,inpF_name);
  reset(inpF);
  write  ('ot@C ... ');
  readln(outpF_name);
  assign(outpF,outpF_name);
  rewrite(outpF);
  write  ('p[Zgグ邩 ... '); 
  readln(percentage);
  ;
  for siro_No := 0 to 208 do
  begin
    read(inpF,rec); {ǂ}
    write(outpF,rec)
  end;  
  for siro_No := 209 to 249 do
  begin
    read(inpF,rec);
    new_level := round(rec.level * (1+percentage/100));
    if new_level > 40 then
      rec.level := 40
    else
      rec.level := new_level;   
    write(outpF,rec)
  end;
  ;
  close(inpF);
  close(outpF)
end; {of kyuusyuu_siro_kyouka}


begin {of main}
  select := 0;
  while select <> 99 do
  begin
    clrscr;
    writeln('@uVṽf[^𑀍삷vO@');
    writeln;
    writeln('PD"BUSYO.BIN" GfBbgB');
    writeln('QD"TURN.BIN"@̓e\BEEEʓrǂ̂Ŕp~');
    writeln('RDBn̔̕\͂B');
    writeln('SD̔\͂_ɐݒ肷B');
    writeln('TD̂Ƃł҂̈ꗗ\쐬B');
    writeln('UD"DAIMYO.BIN" GfBbgB');
    writeln('VDJn喼IvOB');
    writeln('WD"SIRO.BIN" GfBbgB');
    writeln('XD"KUNI.BIN" GfBbgB'); 
    writeln('POD̓oꍑ𕪎UB');  
    writeln('PPDBn̏郌xグB'); 
    writeln('XXDIB');
    readln(select);
    case select of
      1 : edit_BUSYO_BIN;
      2 : display_TURN_BIN;
      3 : spoil_kyuusyuu;
      4 : randomize_nouryoku;
      5 : atotugi;
      6 : edit_DAIMYO_BIN;
      7 : kaisi_daimyou_suu;
      8 : edit_SIRO_BIN;
      9 : edit_KUNI_BIN;
      10 : busyou_bunsan;
      11 : kyuusyuu_siro_kyouka
    end
  end
end.
