{$MODE DELPHI}
unit Crt2;
{ Crt unit  Free Pascal 2.2.2  {\łȂȂ̂ }
{ Free Pascal 3.2.2punităTuZbg쐬BB             }
{ S̎ʎqT|[głĂ͂ȂB                              }
{ ł邾ANSIGXP[vV[PXɒuB                      }
{ Windows ^[~ipiANSIGXP[vV[PXgjB          }
{ 2025/9/7 쐬                                                       }
{ 2025/9/8 ɖ֌WȏC                                         }

interface

Const
{ CRT modes } //gpȂ
  BW40          = 0;            { 40x25 B/W on Color Adapter }
  CO40          = 1;            { 40x25 Color on Color Adapter }
  BW80          = 2;            { 80x25 B/W on Color Adapter }
  CO80          = 3;            { 80x25 Color on Color Adapter }
  Mono          = 7;            { 80x25 on Monochrome Adapter }
  Font8x8       = 256;          { Add-in for ROM font }

{ Mode constants for 3.0 compatibility } //gpȂ
  C40           = CO40;
  C80           = CO80;

{ Foreground and background color constants }
  Black         = 0;
  Blue          = 1;
  Green         = 2;
  Cyan          = 3;
  Red           = 4;
  Magenta       = 5;
  Brown         = 6;
  LightGray     = 7;

{ Foreground color constants }
  DarkGray      = 8;
  LightBlue     = 9;
  LightGreen    = 10;
  LightCyan     = 11;
  LightRed      = 12;
  LightMagenta  = 13;
  Yellow        = 14;
  White         = 15;

{ Add-in for blinking } //Crtjbgł삵Ȃ
  Blink         = 128;

var

{ Interface variables }
  CheckBreak: Boolean;    { Enable Ctrl-Break } //ReferenceɎgpĂȂƏĂ
  CheckEOF: Boolean;      { Enable Ctrl-Z } //ReferenceɎgpĂȂƏĂ
  DirectVideo: Boolean;   { Enable direct video addressing } //ReferenceDOSpƏĂ
  CheckSnow: Boolean;     { Enable snow filtering } //ReferenceɎgpĂȂƏĂ
  LastMode: Word = 3;         { Current text mode } //ReferenceDOSpƏĂ
  TextAttr: Byte = $07;         { Current text attribute } //gpȂ
  WindMin: Word  = $0;          { Window upper left coordinates } //gpȂ
  WindMax: Word  = $184f;          { Window lower right coordinates } //gpȂ
  { FPC Specific for large screen support } //gpȂ
  WindMinX : DWord;
  WindMaxX : DWord;
  WindMinY : DWord;
  WindMaxY : DWord;

type
  { all crt unit coordinates are 1-based }
  tcrtcoord = 1..255;

{ Interface procedures }
procedure AssignCrt(var F: Text); //Ή
function KeyPressed: Boolean;
function ReadKey: Char;
procedure TextMode (Mode: word); //ReferenceDOSpƏĂ
{ Window parameters not changed to tcrtcoord, because the window() procedure
  does nothing if (x1 > x2) or (y1 > y2), and some people may set x2 or y2
  to 0 if they don't want it to do anything (JM)
}
procedure Window(X1,Y1,X2,Y2: Byte); //Ή
procedure GotoXY(X,Y: tcrtcoord);
function WhereX: tcrtcoord;
function WhereY: tcrtcoord;
procedure ClrScr;
procedure ClrEol;
procedure InsLine;
procedure DelLine;
procedure TextColor(Color: Byte);
procedure TextBackground(Color: Byte);
procedure LowVideo; //̉
procedure HighVideo; //őpł
procedure NormVideo;
procedure Delay(MS: Word);
procedure Sound(Hz: Word); //ΉiCrtjbgł삵Ȃj
procedure NoSound; //ΉiCrtjbgł삵Ȃj

{Extra Functions}
procedure cursoron;
procedure cursoroff;
procedure cursorbig; //ΉiCrtjbgł삵Ȃj

procedure SetSafeCPSwitching(Switching:Boolean); //sgp
procedure SetUseACP(ACP:Boolean); //sgp
procedure Window32(X1,Y1,X2,Y2: DWord); //Ή
procedure GotoXY32(X,Y: DWord);
function WhereX32: DWord;
function WhereY32: DWord;

implementation

uses Windows, SysUtils;

procedure SetSafeCPSwitching(Switching:Boolean);
begin
  //sgp
end;

procedure SetUseACP(ACP:Boolean);
begin
  //sgp
end;

procedure TextMode (Mode: word);
begin
  //ReferenceDOSpƏĂ
end;

procedure TextColor(Color: Byte);
begin
  case Color of
    Black:        Write(^[, '[30m');
    Blue:         Write(^[, '[34m');
    Green:        Write(^[, '[32m');
    Cyan:         Write(^[, '[36m');
    Red:          Write(^[, '[31m');
    Magenta:      Write(^[, '[35m');
    Brown:        Write(^[, '[38;5;94m');
    LightGray:    Write(^[, '[1;37m');
    DarkGray:     Write(^[, '[90m');
    LightBlue:    Write(^[, '[94m');
    LightGreen:   Write(^[, '[92m');
    LightCyan:    Write(^[, '[96m');
    LightRed:     Write(^[, '[91m');
    LightMagenta: Write(^[, '[95m');
    Yellow:       Write(^[, '[93m');
    White:        Write(^[, '[97m')
  end;
end;

procedure TextBackground(Color: Byte);
begin
  case Color of
    Black:        Write(^[, '[40m');
    Blue:         Write(^[, '[44m');
    Green:        Write(^[, '[42m');
    Cyan:         Write(^[, '[46m');
    Red:          Write(^[, '[41m');
    Magenta:      Write(^[, '[45m');
    Brown:        Write(^[, '[48;5;94m');
    LightGray:    Write(^[, '[47m');
    DarkGray:     Write(^[, '[100m');
    LightBlue:    Write(^[, '[104m');
    LightGreen:   Write(^[, '[102m');
    LightCyan:    Write(^[, '[106m');
    LightRed:     Write(^[, '[101m');
    LightMagenta: Write(^[, '[105m');
    Yellow:       Write(^[, '[103m');
    White:        Write(^[, '[107m')
  end;
end;

Procedure HighVideo;
{ Set highlighted output. }
Begin
  Write(^[, '[1m') //őpł
End;

Procedure LowVideo;
{ Set normal output }
Begin
  Write(^[, '[22m') //̉
End;

Procedure NormVideo;
{ Set normal back and foregroundcolors. }
Begin
  Write(^[, '[0m')
End;

Procedure GotoXY(X: tcrtcoord; Y: tcrtcoord);
begin
  GotoXY32(X,Y);
end;

Procedure GotoXY32(X: DWord; Y: DWord);
Begin
  Write(^[, '[', IntToStr(Y), ';', IntToStr(X), 'H')
End;

Procedure Window(X1, Y1, X2, Y2: Byte);
begin
  Window32(X1,Y1,X2,Y2);
end;

Procedure Window32(X1, Y1, X2, Y2: DWord);
Begin
  //Ή
End;

procedure ClrScr;
begin
  Write(^[, '[2J');
  GotoXY(1, 1)
end;

procedure ClrEol;
begin
  Write(^[, '[K')
end;

function WhereX: tcrtcoord;
begin
  WhereX:=WhereX32 mod 256;
end;

function WhereX32: DWord; //Google Gemini쐬R[h
var
  hConsoleOutput: THandle;
  csbi: CONSOLE_SCREEN_BUFFER_INFO;
begin
  // Wo͂̃nh擾
  hConsoleOutput := GetStdHandle(STD_OUTPUT_HANDLE);
  // ʃobt@̏擾
  GetConsoleScreenBufferInfo(hConsoleOutput, csbi);
  // \̂J[\ʒuXW𒊏o
  Result := csbi.dwCursorPosition.X + 1 // Windows API0x[XȂ̂1𑫂
end;

function WhereY: tcrtcoord;
begin
  WhereY:=WhereY32 mod 256;
end;

function WhereY32: DWord; //Google Gemini쐬R[h
var
  hConsoleOutput: THandle;
  csbi: CONSOLE_SCREEN_BUFFER_INFO;
begin
  // Wo͂̃nh擾
  hConsoleOutput := GetStdHandle(STD_OUTPUT_HANDLE);
  // ʃobt@̏擾
  GetConsoleScreenBufferInfo(hConsoleOutput, csbi);
  // \̂J[\ʒuYW𒊏o
  Result := csbi.dwCursorPosition.Y + 1 // Windows API0x[XȂ̂1𑫂
end;



{*************************************************************************
                            KeyBoard
*************************************************************************}

var
   ScanCode : char;
   SpecialKey : boolean;
   DoingNumChars: Boolean;
   DoingNumCode: Byte;

Function RemapScanCode (ScanCode: word; CtrlKeyState: dword; keycode:word): byte;
  { Several remappings of scancodes are necessary to comply with what
    we get with MSDOS. Special Windows keys, as Alt-Tab, Ctrl-Esc etc.
    are excluded }
var
  AltKey, CtrlKey, ShiftKey: boolean;
const
  {
    Keypad key scancodes:

      Ctrl Norm

      $77  $47 - Home
      $8D  $48 - Up arrow
      $84  $49 - PgUp
      $8E  $4A - -
      $73  $4B - Left Arrow
      $8F  $4C - 5
      $74  $4D - Right arrow
      $4E  $4E - +
      $75  $4F - End
      $91  $50 - Down arrow
      $76  $51 - PgDn
      $92  $52 - Ins
      $93  $53 - Del
  }
  CtrlKeypadKeys: array[$47..$53] of byte =
    ($77, $8D, $84, $8E, $73, $8F, $74, $4E, $75, $91, $76, $92, $93);

begin
  AltKey := ((CtrlKeyState AND
            (RIGHT_ALT_PRESSED OR LEFT_ALT_PRESSED)) > 0);
  CtrlKey := ((CtrlKeyState AND
            (RIGHT_CTRL_PRESSED OR LEFT_CTRL_PRESSED)) > 0);
  ShiftKey := ((CtrlKeyState AND SHIFT_PRESSED) > 0);

  if AltKey then
   begin
    case ScanCode of
    // Digits, -, =
    $02..$0D: inc(ScanCode, $76);
    // Function keys
    $3B..$44: inc(Scancode, $2D);
    $57..$58: inc(Scancode, $34);
    // Extended cursor block keys
    $47..$49, $4B, $4D, $4F..$53:
              inc(Scancode, $50);
    // Other keys
    $1C:      Scancode := $A6;   // Enter
    $35:      Scancode := $A4;   // / (keypad and normal!)
    end
   end
  else if CtrlKey then
    case Scancode of
    // Tab key
    $0F:      Scancode := $94;
    // Function keys
    $3B..$44: inc(Scancode, $23);
    $57..$58: inc(Scancode, $32);
    // Keypad keys
    $35:      Scancode := $95;   // \
    $37:      Scancode := $96;   // *
    $47..$53: Scancode := CtrlKeypadKeys[Scancode];
    //Enter on Numpad
    $1C:
    begin
      Scancode := $0A;
      SpecialKey := False;
    end;
    end
  else if ShiftKey then
    case Scancode of
    // Function keys
    $3B..$44: inc(Scancode, $19);
    $57..$58: inc(Scancode, $30);
    //Enter on Numpad
    $1C:
    begin
      Scancode := $0D;
      SpecialKey := False;
    end;
    end
  else
    case Scancode of
      // Function keys
      $57..$58: inc(Scancode, $2E); // F11 and F12
      //Enter on NumPad
      $1C:
        begin
          Scancode := $0D;
          SpecialKey := False;
        end;
  end;
  RemapScanCode := ScanCode;
end;


function KeyPressed : boolean;
var
  nevents,nread : dword;
  buf : TINPUTRECORD;
  AltKey: Boolean;
  c : longint;
begin
  KeyPressed := FALSE;
  if ScanCode <> #0 then
    KeyPressed := TRUE
  else
   begin
     GetNumberOfConsoleInputEvents(TextRec(input).Handle,nevents);
     while nevents>0 do
       begin
          ReadConsoleInputA(TextRec(input).Handle,buf,1,nread);
          if buf.EventType = KEY_EVENT then
            if buf.Event.KeyEvent.bKeyDown then
              begin
                 { Alt key is VK_MENU }
                 { Capslock key is VK_CAPITAL }

                 AltKey := ((Buf.Event.KeyEvent.dwControlKeyState AND
                            (RIGHT_ALT_PRESSED OR LEFT_ALT_PRESSED)) > 0);
                 if not(Buf.Event.KeyEvent.wVirtualKeyCode in [VK_SHIFT, VK_MENU, VK_CONTROL,
                                                      VK_CAPITAL, VK_NUMLOCK,
                                                      VK_SCROLL]) then
                   begin
                      keypressed:=true;

                      if (ord(buf.Event.KeyEvent.AsciiChar) = 0) or
                         (buf.Event.KeyEvent.dwControlKeyState and (LEFT_ALT_PRESSED or ENHANCED_KEY) > 0) then
                        begin
                           SpecialKey := TRUE;
                           ScanCode := Chr(RemapScanCode(Buf.Event.KeyEvent.wVirtualScanCode, Buf.Event.KeyEvent.dwControlKeyState,
                                           Buf.Event.KeyEvent.wVirtualKeyCode));
                        end
                      else
                        begin
                           { Map shift-tab }
                           if (buf.Event.KeyEvent.AsciiChar=#9) and
                              (buf.Event.KeyEvent.dwControlKeyState and SHIFT_PRESSED > 0) then
                            begin
                              SpecialKey := TRUE;
                              ScanCode := #15;
                            end
                           else
                            begin
                              SpecialKey := FALSE;
                              ScanCode := Chr(Ord(buf.Event.KeyEvent.AsciiChar));
                            end;
                        end;

                      if AltKey then
                        begin
                           case Buf.Event.KeyEvent.wVirtualScanCode of
                             71 : c:=7;
                             72 : c:=8;
                             73 : c:=9;
                             75 : c:=4;
                             76 : c:=5;
                             77 : c:=6;
                             79 : c:=1;
                             80 : c:=2;
                             81 : c:=3;
                             82 : c:=0;
                           else
                             break;
                           end;
                           DoingNumChars := true;
                           DoingNumCode := Byte((DoingNumCode * 10) + c);
                           Keypressed := false;
                           Specialkey := false;
                           ScanCode := #0;
                        end
                      else
                        break;
                   end;
              end
             else
              begin
                if (Buf.Event.KeyEvent.wVirtualKeyCode in [VK_MENU]) then
               if DoingNumChars then
                 if DoingNumCode > 0 then
                   begin
                      ScanCode := Chr(DoingNumCode);
                      Keypressed := true;

                      DoingNumChars := false;
                      DoingNumCode := 0;
                      break
                   end; { if }
              end;
          { if we got a key then we can exit }
          if keypressed then
            exit;
          GetNumberOfConsoleInputEvents(TextRec(input).Handle,nevents);
       end;
   end;
end;


function ReadKey: char;
begin
  while (not KeyPressed) do
    Sleep(1);
  if SpecialKey then begin
    ReadKey := #0;
    SpecialKey := FALSE;
  end else begin
    ReadKey := ScanCode;
    ScanCode := #0;
  end;
end;



procedure Delay(MS: Word);
begin
  Sleep(ms);
end; { proc. Delay }

procedure Sound(Hz: Word);
begin
  //ΉiCrtjbgł삵Ȃj
end;

procedure NoSound;
begin
  //ΉiCrtjbgł삵Ȃj
end;

procedure DelLine;
begin
  Write(^[, '[1M')
end;

procedure InsLine;
begin
  Write(^[, '[1L')
end;

procedure cursoron;
begin
  Write(^[, '[?25h')
end;

procedure cursoroff;
begin
  Write(^[, '[?25l')
end;

procedure cursorbig;
begin
  //ΉiCrtjbgł삵Ȃj
end;

procedure AssignCrt(var F: Text);
begin
  //Ή
end;

end.
