{$MODE DELPHI}
unit TenkaALib;
{ uVAdvanceṽf[^ǂނ߂̃Cu[ }
{ TenkaLib ύXč쐬  2021/3/9                   }

interface

type
  year_type = 1551..1623;
  season_type = (spring,summer,fall,winter);
  kuni_type = 0..66;
  sihai_type = (misihai,hansihai,zensihai);
  tousyu_type = 0..840;
  kokumei_type = string[6];
  tihou_type = 0..9;

procedure read_TURN_BIN(inpF_name:string);

function TURN_current_turn : word;

function TURN_kokudaka(y:year_type; s:season_type):word;

function TURN_zyun_i(y:year_type; s:season_type):byte;

function TURN_sihai(y:year_type; s:season_type; k:kuni_type):sihai_type;

function TURN_tousyu(y:year_type; s:season_type):tousyu_type;

function TURN_kokumei(k:kuni_type):kokumei_type;


implementation

var
  TURN_tousyu_array : array[year_type,season_type] of word;
  TURN_kokudaka_array : array[year_type,season_type] of word;
  TURN_zyun_i_array : array[year_type,season_type] of byte;
  TURN_sihai_array : array[year_type,kuni_type] of byte;

const
  kokumei_const : array[kuni_type] of kokumei_type =
    ('k','','엤','koH','oH','  헤','  ','  㑍',
     '  [','  ','  ','  ','  ','  ɓ','  x','  ]',
     '  O','  ','  Z','  ɐ','  b','kMZ','MZ','  ',
     '  z','  z','  \o','  ','  zO','  ዷ','kߍ]','ߍ]',
     '  ɉ','  R','  Og','  ے','  ͓','  a','  a','  I',
     '  O','  An','  ','  ','  o_','  Ό','  d','  ',
     '  O','  ','  ','  |','  h','  ','  g','  ]',
     '  ɗ\','  y','  LO','  L','  }O','  }','  O','  ',
     '  ','  ','  F');

procedure read_TURN_BIN(inpF_name:string);
var
  inpF : file;
begin
  assign(inpF,inpF_name);
  reset(inpF,1);
  blockread(inpF,TURN_tousyu_array,72*4*2);
  blockread(inpF,TURN_kokudaka_array,72*4*2);
  blockread(inpF,TURN_zyun_i_array,72*4*1);
  blockread(inpF,TURN_sihai_array,72*67*1);
  close(inpF)
end;

function TURN_current_turn : word;
var
  n : word;
  y : year_type;
  s : season_type;
begin
  n := 1;
  for y := 1551 to 1623 do
  begin
    for s := spring to winter do
    begin
      if TURN_zyun_i_array[y,s] <> 0 then inc(n)
      else
      begin
	TURN_current_turn := n - 1;
	exit
      end
    end
  end
end;

function TURN_kokudaka(y:year_type; s:season_type):word;
begin
  TURN_kokudaka := TURN_kokudaka_array[y,s]
end;

function TURN_zyun_i(y:year_type; s:season_type):byte;
begin
  TURN_zyun_i := TURN_zyun_i_array[y,s]
end;

function TURN_sihai(y:year_type; s:season_type; k:kuni_type):sihai_type;
var
  data : byte;
begin
  data := TURN_sihai_array[y,k];
  TURN_sihai := sihai_type((data shr (byte(s)*2)) and 3);
end;
{̎xz󋵂͂PoCgŎ̂悤ɕ\ĂB                    }
{f[^QSĝƂƁA                                        }
{    Q   S                                                           }
{  00 10 01 00                                                         }
{EAtOOAāOPAHPOA~OOŁAOO͖xzAOP}
{xzAPO͑SxzӖĂB                                  }

function TURN_tousyu(y:year_type; s:season_type):tousyu_type;
begin
  TURN_tousyu := TURN_tousyu_array[y,s]
end;

function TURN_kokumei(k:kuni_type):kokumei_type;
begin
  TURN_kokumei := kokumei_const[k]
end;


end.