unit Unit1;
{ TenkaFRN             }
{ March 6, 2002  by Yoshitan }
interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, FolderDialog2;

type
  TForm1 = class(TForm)
    ScenarioGroup: TRadioGroup;
    SaveDataGroup: TRadioGroup;
    Button1: TButton;
    Button2: TButton;
    Button3: TButton;
    FolderDialog1: TFolderDialog;
    Label1: TLabel;
    procedure Button3Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ScenarioGroupClick(Sender: TObject);
    procedure SaveDataGroupClick(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private 錾 }
  public
    { Public 錾 }
  end;

var
  Form1: TForm1;

implementation

uses IniFiles, Process;

{$R *.DFM}

const
  Dashes = '---';

var
  BaseDir: string;
  IniFile: TIniFile;
  PrevSaveDataIndex: Integer;

procedure TForm1.Button3Click(Sender: TObject);
begin
  Application.Terminate
end;

procedure UpdateScreen;
var
  st: string;
  n: Integer;
begin
  with Form1 do
  begin
    SaveDataGroup.ItemIndex := IniFile.ReadInteger('TenkaARN', 'SaveData', -1);
    for n := 0 to SaveDataGroup.Items.Count - 1 do
    begin
      st := BaseDir + Copy(SaveDataGroup.Items[n], 1, 8) + '\SYSTEM.BIN';
      if FileExists(st) then
        SaveDataGroup.Items[n] := Copy(SaveDataGroup.Items[n], 1, 8)
          + FormatDateTime('  dddddd hh:nn', FileDateToDateTime(FileAge(st)))
      else
        SaveDataGroup.Items[n] := Copy(SaveDataGroup.Items[n], 1, 8)
          + '  ' + Dashes
    end
  end
end;

procedure TForm1.Button2Click(Sender: TObject);
begin
  if FolderDialog1.Execute then
  begin
    BaseDir := FolderDialog1.Directory + '\';
    IniFile.WriteString('TenkaARN', 'BaseDir', BaseDir);
    IniFile.WriteInteger('TenkaARN', 'SaveData', -1);
    IniFile.UpdateFile;
    UpdateScreen
  end
end;

procedure TForm1.FormCreate(Sender: TObject);
var
  st: string;
begin
  IniFile := TIniFile.Create(Copy(Paramstr(0), 1, Length(Paramstr(0)) - 4) +
    '.ini');
  st := IniFile.ReadString('TenkaARN', 'BaseDir', 'Error');
  if (st = 'Error') or (st = '') then
    Button2Click(Sender)
  else
  begin
    BaseDir := st;
    if st[Length(st)] = '\' then Delete(st, Length(st), 1);
    FolderDialog1.Directory := st;
    UpdateScreen
  end
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  IniFile.WriteInteger('TenkaARN', 'SaveData', SaveDataGroup.ItemIndex);
  IniFile.UpdateFile;
  IniFile.Free
end;

procedure TForm1.ScenarioGroupClick(Sender: TObject);
begin
  Beep;
  ScenarioGroup.ItemIndex := 0
end;

procedure TForm1.SaveDataGroupClick(Sender: TObject);
var
  st: string;
begin
  st := SaveDataGroup.Items[SaveDataGroup.ItemIndex];
  if Copy(st, Length(st) - 2, 3)= Dashes then
  begin
    Beep;
    SaveDataGroup.ItemIndex := PrevSaveDataIndex;
  end;
  PrevSaveDataIndex := SaveDataGroup.ItemIndex
end;

procedure TForm1.Button1Click(Sender: TObject);
begin
  if (ScenarioGroup.ItemIndex = -1) or (SaveDataGroup.ItemIndex = -1) then
  begin
    Beep;
    Exit
  end;
  if MessageDlg('s܂?',
    mtConfirmation, [mbYes, mbNo], 0) = mrYes then
    Execute(BaseDir + Copy(ScenarioGroup.Items[ScenarioGroup.ItemIndex], 1, 7)
      + '\', BaseDir + Copy(SaveDataGroup.Items[SaveDataGroup.ItemIndex], 1, 8)
      + '\')
end;

end.
