{$A-}
unit Process;

interface

procedure Execute(ScenarioPath, SaveDataPath: string);

implementation

uses SysUtils, Dialogs;

type
  TBusyo = record
             Others1: array[1..6] of Byte;
             Name: array[1..12] of Char;
             Others2: array[1..20] of Byte
           end;

var
  ScenarioBusyoF, SaveDataBusyoF: file of TBusyo;
  ScenarioBusyo, SaveDataBusyo: TBusyo;

procedure Execute(ScenarioPath, SaveDataPath: string);
var
  n, m: Integer;
  st: string;
begin
  AssignFile(ScenarioBusyoF, ScenarioPath + 'BUSYO21.BIN');
  Reset(ScenarioBusyoF);
  AssignFile(SaveDataBusyoF, SaveDataPath + 'BUSYO21.BIN');
  Reset(SaveDataBusyoF);
  for n := 0 to 1999 do
  begin
    Seek(ScenarioBusyoF, n);
    Read(ScenarioBusyoF, ScenarioBusyo);
    Seek(SaveDataBusyoF, n);
    Read(SaveDataBusyoF, SaveDataBusyo);
    if ScenarioBusyo.Name <> SaveDataBusyo.Name then
    begin
      if SaveDataBusyo.Name <> ScenarioBusyo.Name then st := ScenarioBusyo.Name;
      if st[7] <> ' ' {O3̏ꍇ} then
        st := Copy(st, 1, 9) + 'k'
      else
        st := Copy(st, 1, 6) + Format('%6s', [Trim(Copy(st, 7, 6)) + 'k']);
      for m := 1 to 12 do SaveDataBusyo.Name[m] := st[m];
      Seek(SaveDataBusyoF, n);
      Write(SaveDataBusyoF, SaveDataBusyo)
    end
  end;
  CloseFile(ScenarioBusyoF);
  CloseFile(SaveDataBusyoF);
  ShowMessage('f[^܂.')
end;

end.

