unit FolderDialog2;
  { tH_[I_CAOR|[lgȈՔ Ver 1.0
     Copyright(C) 1998 H-Triton  All Rights Reserved  }

  { Modified by yoshitani  April 24, 1999

    g_ 1. Root desktopɂ邩ۂwłB
           2. tH_̃^CvAPIɑΉĐݒłBAPĨwvp...

BIF_BROWSEFORCOMPUTER	Only returns computers. If the user selects anything other than a computer, the OK button is grayed.
BIF_BROWSEFORPRINTER	Only returns printers. If the user selects anything other than a printer, the OK button is grayed.
BIF_DONTGOBELOWDOMAIN	Does not include network folders below the domain level in the tree view control.
BIF_RETURNFSANCESTORS	Only returns file system ancestors. If the user selects anything other than a file system ancestor, the OK button is grayed.
BIF_RETURNONLYFSDIRS	Only returns file system directories. If the user selects folders that are not part of the file system, the OK button is grayed.
BIF_STATUSTEXT	Includes a status area in the dialog box. The callback function can set the status text by sending messages to the dialog box.
  }

interface

uses
  Windows, Messages, Classes, Controls, FileCtrl, ShlObj, ActiveX;

type
  TOption = (ofBrowseForComputer, ofBrowseForPrinter, ofDontGoBelowDomain,
             ofReturnFSAncestors, ofReturnOnlyFSDirs,
             ofStatusText);  //Added by yoshitan
  TOptions = set of TOption;
  TFolderDialog = class(TComponent)
  private
    FDirectory: string;
    FTitle: string;
    FRootIsDesktop : boolean;
    FOptions : TOptions;
  protected
    { Protected 錾 }
  public
    constructor Create( AOwner : TComponent ); override;
    property Directory: string read FDirectory write FDirectory;
    function Execute: Boolean;
  published
    property Title: string read FTitle write FTitle;
    property RootIsDesktop: boolean read FRootIsDesktop
      write FRootIsDesktop; //Added by yoshitan
    property Options: TOptions read FOptions write FOptions
               default [ofStatusText]; //Added by yoshitan
    { Published 錾 }
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('MyCompo', [TFolderDialog]);
end;

// RXgN^
constructor TFolderDialog.Create( AOwner : TComponent );
begin
  inherited Create( AOwner );
  FDirectory:= '';
  FTitle:= 'tH_[̑I';
  FRootIsDesktop := false; //Added by yoshitan
  include(FOptions, ofStatusText) // Added by yoshitan
end;

// _CAOݒR[obN֐
function BrowseCallbackProc(Wnd: HWND; uMsg: UINT; LParam, lpData: LPARAM): Integer stdCall;
var
  Path: array[0..511] of Char;
  aText: string;
begin
  Result:= 0;
  Path:= '';
  // \ߊJtH_[bZ[Wʒm
  with TFolderDialog(lpData) do
    if (uMsg = BFFM_INITIALIZED) and DirectoryExists(FDirectory) then
      SendMessage(Wnd, BFFM_SETSELECTION, 1, LongInt(PChar(FDirectory)));
  // [U[ύXtH_[pX擾
  if uMsg = BFFM_SELCHANGED then
    SHGetPathFromIDList(PItemIDList(lParam), Path);
  // ύXꂽtH_[pXbZ[Wʒmĕ\
  aText:= string(Path);
  SendMessage(Wnd, BFFM_SETSTATUSTEXT, 0, LongInt(PChar(aText)));
end;

// J\bh|_CAOJ
function TFolderDialog.Execute: Boolean;
var
  hRet: HResult;
  ppMalloc: IMalloc;
  bi: TBrowseInfo;
  pBuf: PChar;
  pidlRoot, pidlBrowse: PItemIDList;
begin
  Result:= False;
  SHGetMalloc(ppMalloc);
  try
    pBuf := ppMalloc.Alloc(MAX_PATH);
    if pBuf = nil then Exit;
    // uϲ ߭vtH_[̃P[V̎擾...
    hRet:= SHGetSpecialFolderLocation
      ((Owner as TWinControl).Handle, CSIDL_DRIVES, pidlRoot);
    if not Succeeded(hRet) then
    begin
      ppMalloc.Free(pBuf);
      Exit;
    end;
    // Browse Information\̂̐ݒ
    bi.hwndOwner := (Owner as TWinControl).Handle;
    bi.pidlRoot  := pidlRoot;
    if FRootIsDesktop then bi.pidlRoot := nil; //Added by yoshitan
    bi.pszDisplayName := pBuf;
    bi.lpszTitle := PChar(FTitle);
    bi.ulFlags   := BIF_STATUSTEXT;

    //Added by yoshitan
    bi.ulFlags := 0;
    bi.ulFlags := bi.ulFlags + longword(ord(ofBrowseForComputer in FOptions)
                                        * BIF_BROWSEFORCOMPUTER);
    bi.ulFlags := bi.ulFlags + longword(ord(ofBrowseForPrinter in FOptions)
                                        * BIF_BROWSEFORPRINTER);
    bi.ulFlags := bi.ulFlags + longword(ord(ofDontGoBelowDomain in FOptions)
                                        * BIF_DONTGOBELOWDOMAIN);
    bi.ulFlags := bi.ulFlags + longword(ord(ofReturnFSAncestors in FOptions)
                                        * BIF_RETURNFSANCESTORS);
    bi.ulFlags := bi.ulFlags + longword(ord(ofReturnOnlyFSDirs in FOptions)
                                        * BIF_RETURNONLYFSDIRS);
    bi.ulFlags := bi.ulFlags + longword(ord(ofStatusText in FOptions)
                                        * BIF_STATUSTEXT);

    bi.lpfn      := BrowseCallbackProc;
    bi.lParam    := LongInt(Self);
    pidlBrowse := SHBrowseForFolder(bi);
    if pidlBrowse <> nil then
    begin
      Result:= True;
      if SHGetPathFromIDList(pidlBrowse, pBuf) then FDirectory:= string(pBuf);
      ppMalloc.Free(pidlBrowse); // ͖̉Yꂸ
    end;
    ppMalloc.Free(pidlRoot);  // ͖̉Yꂸ...
    ppMalloc.Free(pBuf);
  finally
    ppMalloc._Release; // VF̃^XNAP[^[̉
  end;
end;

end.
